/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.NnuId;
import javax.media.j3d.NnuIdManager;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;

class GeometryAtom
implements BHLeafInterface,
NnuId {
    GeometryRetained[] geometryArray = null;
    Transform3D[] lastLocalTransformArray = null;
    Locale locale = null;
    Shape3DRetained source = null;
    BHLeafNode bhLeafNode = null;
    boolean alphaEditable;
    boolean visible = true;
    int geoType = -1;
    RenderAtom[] renderAtoms = new RenderAtom[0];
    int nnuId;
    Point3d[] centroid = null;
    boolean centroidIsDirty = true;
    Object lockObj = new Object();

    GeometryAtom() {
        this.nnuId = NnuIdManager.getId();
    }

    public int getId() {
        return this.nnuId;
    }

    public int equal(NnuId nnuId) {
        int n2 = nnuId.getId();
        if (this.nnuId < n2) {
            return -1;
        }
        if (this.nnuId > n2) {
            return 1;
        }
        return 0;
    }

    public BoundingBox computeBoundingHull() {
        return this.source.vwcBounds;
    }

    public boolean isEnable() {
        return this.source.vwcBounds != null && !this.source.vwcBounds.isEmpty() && this.source.switchState.currentSwitchOn;
    }

    public boolean isEnable(int n2) {
        if (this.source.vwcBounds != null && !this.source.vwcBounds.isEmpty() && this.source.switchState.currentSwitchOn) {
            switch (n2) {
                case 0: {
                    return this.visible;
                }
                case 1: {
                    return !this.visible;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    public Locale getLocale2() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RenderAtom getRenderAtom(View view) {
        RenderAtom[] renderAtomArray = this.renderAtoms;
        synchronized (this.renderAtoms) {
            int n2 = view.viewIndex;
            if (n2 >= this.renderAtoms.length) {
                RenderAtom renderAtom;
                int n3;
                if (this.source.viewList != null && !this.source.viewList.contains(view)) {
                    // ** MonitorExit[var4_2] (shouldn't be in output)
                    return null;
                }
                RenderAtom[] renderAtomArray2 = new RenderAtom[n2 + 1];
                for (n3 = 0; n3 < this.renderAtoms.length; ++n3) {
                    renderAtomArray2[n3] = this.renderAtoms[n3];
                }
                renderAtomArray2[n2] = renderAtom = new RenderAtom();
                renderAtomArray2[n2].geometryAtom = this;
                renderAtom.rListInfo = new RenderAtomListInfo[this.geometryArray.length];
                if (this.geoType != 16) {
                    for (n3 = 0; n3 < renderAtom.rListInfo.length; ++n3) {
                        renderAtom.rListInfo[n3] = new RenderAtomListInfo();
                        renderAtom.rListInfo[n3].renderAtom = renderAtom;
                        renderAtom.rListInfo[n3].index = n3;
                    }
                } else {
                    for (n3 = 0; n3 < renderAtom.rListInfo.length; ++n3) {
                        renderAtom.rListInfo[n3] = new RenderAtomListInfo();
                        renderAtom.rListInfo[n3].renderAtom = renderAtom;
                        renderAtom.rListInfo[n3].index = n3;
                        renderAtom.rListInfo[n3].localToVworld = new Transform3D();
                    }
                }
                this.renderAtoms = renderAtomArray2;
            } else if (this.renderAtoms[n2] == null) {
                RenderAtom renderAtom;
                if (this.source.viewList != null && !this.source.viewList.contains(view)) {
                    // ** MonitorExit[var4_2] (shouldn't be in output)
                    return null;
                }
                this.renderAtoms[n2] = renderAtom = new RenderAtom();
                this.renderAtoms[n2].geometryAtom = this;
                renderAtom.rListInfo = new RenderAtomListInfo[this.geometryArray.length];
                if (this.geoType != 16) {
                    for (int i2 = 0; i2 < renderAtom.rListInfo.length; ++i2) {
                        renderAtom.rListInfo[i2] = new RenderAtomListInfo();
                        renderAtom.rListInfo[i2].renderAtom = renderAtom;
                        renderAtom.rListInfo[i2].index = i2;
                    }
                } else {
                    for (int i3 = 0; i3 < renderAtom.rListInfo.length; ++i3) {
                        renderAtom.rListInfo[i3] = new RenderAtomListInfo();
                        renderAtom.rListInfo[i3].renderAtom = renderAtom;
                        renderAtom.rListInfo[i3].index = i3;
                        renderAtom.rListInfo[i3].localToVworld = new Transform3D();
                    }
                }
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return this.renderAtoms[n2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCentroid() {
        if (VirtualUniverse.mc.sortShape3DBounds && !this.source.boundsAutoCompute) {
            Object object = this.lockObj;
            synchronized (object) {
                if (this.centroid == null) {
                    this.centroid = new Point3d[this.geometryArray.length];
                    for (int i2 = 0; i2 < this.centroid.length; ++i2) {
                        this.centroid[i2] = new Point3d(this.source.localBounds.getCenter());
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[i2]);
                    }
                } else {
                    for (int i3 = 0; i3 < this.centroid.length; ++i3) {
                        this.centroid[i3].set(this.source.localBounds.getCenter());
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[i3]);
                    }
                }
            }
            return;
        }
        Object object = this.lockObj;
        synchronized (object) {
            int n2;
            for (n2 = 0; n2 < this.geometryArray.length; ++n2) {
                if (this.geometryArray[n2] == null) continue;
                Point3d point3d = this.geometryArray[n2].centroid;
                synchronized (point3d) {
                    if (this.geometryArray[n2].recompCentroid) {
                        this.geometryArray[n2].computeCentroid();
                        this.geometryArray[n2].recompCentroid = false;
                    }
                    continue;
                }
            }
            if (this.centroidIsDirty) {
                if (this.centroid == null) {
                    this.centroid = new Point3d[this.geometryArray.length];
                    for (n2 = 0; n2 < this.centroid.length; ++n2) {
                        if (this.geometryArray[n2] == null) continue;
                        this.centroid[n2] = new Point3d(this.geometryArray[n2].centroid);
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[n2]);
                    }
                } else {
                    for (n2 = 0; n2 < this.centroid.length; ++n2) {
                        if (this.geometryArray[n2] == null) continue;
                        this.centroid[n2].set(this.geometryArray[n2].centroid);
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[n2]);
                    }
                }
                this.centroidIsDirty = false;
            }
        }
    }
}

